/**
 * Kitstarter Settings Page JavaScript
 */
(function ($) {
    'use strict';

    $(document).ready(function () {
        var $form = $('#kitstarter-settings-form');
        var $message = $('#kitstarter-settings-message');

        $form.on('submit', function (e) {
            e.preventDefault();

            var editorVersion = $('#kitstarter_editor_version').val();

            $.ajax({
                url: kitstarter_settings.ajax_url,
                type: 'POST',
                data: {
                    action: 'kitstarter_save_settings',
                    nonce: kitstarter_settings.nonce,
                    editor_version: editorVersion
                },
                beforeSend: function () {
                    $form.find('input[type="submit"]').prop('disabled', true);
                },
                success: function (response) {
                    if (response.success) {
                        $message
                            .removeClass('notice-error')
                            .addClass('notice notice-success')
                            .html('<p>' + response.data.message + '</p>')
                            .show();
                    } else {
                        $message
                            .removeClass('notice-success')
                            .addClass('notice notice-error')
                            .html('<p>' + response.data.message + '</p>')
                            .show();
                    }
                },
                error: function () {
                    $message
                        .removeClass('notice-success')
                        .addClass('notice notice-error')
                        .html('<p>An error occurred. Please try again.</p>')
                        .show();
                },
                complete: function () {
                    $form.find('input[type="submit"]').prop('disabled', false);
                    setTimeout(function () {
                        $message.fadeOut();
                    }, 3000);
                }
            });
        });
    });
})(jQuery);
