<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://kitstarter.io
 * @since             0.0.1
 * @package           Kitstarter
 *
 * @wordpress-plugin
 * Plugin Name:       Kitstarter
 * Plugin URI:        https://kitstarter.io/kitstarter
 * Description:       With access to over 800 components you can build beautiful websites and save thousands of hours using the world's largest Elementor component library.
 * Version:           2.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.4
 * Author:            Kitstarter
 * Author URI:        https://kitstarter.io
 * License:           GPLv3
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       kitstarter
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Load configuration variables.
 */
require plugin_dir_path( __FILE__ ) . 'config.php';

/**
 * Currently plugin version.
 * Start at version 0.0.1 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'KITSTARTER_VERSION', '1.0.1' );

/**
 * Define Kitstarter path and uri.
 */
define( 'KITSTARTER_PLUGIN_FILE', __FILE__ );
define( 'KITSTARTER_PATH', plugin_dir_path( __FILE__ ) );
define( 'KITSTARTER_URL', plugin_dir_url( __FILE__ ) );
define( 'KITSTARTER_AUTH_URL', $kitstarter_auth_url );
define( 'KITSTARTER_RESOURCE_URL', $kitstarter_server_url );

define( 'KITSTARTER_BASENAME', plugin_basename( __FILE__ ) );
define( 'KITSTARTER_BASEDIR', plugin_basename( __DIR__ ) );

define( 'KITSTARTER_TESTED_ELEMENTOR_VERSION', '3.4.4' );

/**
 * Include helper functions.
 */
require KITSTARTER_PATH . 'functions.php';

/**
 * Include Autoloader.
 */
require KITSTARTER_PATH . 'app/class-autoloader.php';

/**
 * Initialize the plugin.
 *
 * @since 1.0.0
 * @return void
 */
function kitstarter_init() {
	\Kitstarter\Autoloader::run();
}
add_action( 'plugins_loaded', 'kitstarter_init' );

/**
 * Activation hook to run on plugin activation.
 *
 * @since 1.0.0
 * @return void
 */
function kitstarter_activate() {
	// Actions to perform on plugin activation.
	// For example, creating custom database tables or options.
	// This is just a placeholder for future functionality.
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}
}
register_activation_hook( __FILE__, 'kitstarter_activate' );

/**
 * Deactivation hook to run on plugin deactivation.
 *
 * @since 1.0.0
 * @return void
 */
function kitstarter_deactivate() {
	// Actions to perform on plugin deactivation.
	// For example, cleaning up options or custom database tables.
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}
}
register_deactivation_hook( __FILE__, 'kitstarter_deactivate' );

/**
 * Display admin notice when Elementor is not installed.
 *
 * @since 1.0.0
 * @return void
 */
function kitstarter_admin_notice_missing_main_plugin() {
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Only unsetting 'activate' to suppress misleading notice.
	if ( isset( $_GET['activate'] ) ) {
		unset( $_GET['activate'] );
	}

	$message = sprintf(
		/* translators: 1: Plugin name 2: Elementor */
		esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'kitstarter' ),
		'<strong>' . esc_html__( 'Kitstarter', 'kitstarter' ) . '</strong>',
		'<strong>' . esc_html__( 'Elementor', 'kitstarter' ) . '</strong>'
	);

	printf(
		'<div class="notice notice-warning is-dismissible"><p>%s</p></div>',
		wp_kses_post( $message )
	);
}

/**
 * Display admin notice when Elementor version is too old.
 *
 * @since 1.0.0
 * @return void
 */
function kitstarter_admin_notice_minimum_elementor_version() {
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Only unsetting 'activate' to suppress misleading notice.
	if ( isset( $_GET['activate'] ) ) {
		unset( $_GET['activate'] );
	}

	$message = sprintf(
		/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
		esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'kitstarter' ),
		'<strong>' . esc_html__( 'Kitstarter', 'kitstarter' ) . '</strong>',
		'<strong>' . esc_html__( 'Elementor', 'kitstarter' ) . '</strong>',
		KITSTARTER_TESTED_ELEMENTOR_VERSION
	);

	printf(
		'<div class="notice notice-warning is-dismissible"><p>%s</p></div>',
		wp_kses_post( $message )
	);
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since 1.0.0
 * @return void
 */
function kitstarter_run() {
	// Check if Elementor installed and activated.
	if ( ! did_action( 'elementor/loaded' ) ) {
		add_action( 'admin_notices', 'kitstarter_admin_notice_missing_main_plugin' );
		return;
	}

	// Check for required Elementor version.
	if ( ! version_compare( ELEMENTOR_VERSION, KITSTARTER_TESTED_ELEMENTOR_VERSION, '>=' ) ) {
		add_action( 'admin_notices', 'kitstarter_admin_notice_minimum_elementor_version' );
		return;
	}
}
kitstarter_run();
